--[[---------------------------------------------------------------------------
	Chocolatier Two Simulator: Product Types
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

LProductType =
{
	__tostring = function(i) return "{ProductType:" .. i.name .. "}" end,
	_ByIndex = {},
	_ByName = {},
	
	-- Some defaults
	traycount = 5,
	colorcount = 1,
	traycycle = 30000,
	conveyortime = 1200,
	ingredientrate = 250,
	flytime = 500,
	producttime = 2000,
	speedup = 1.1,
	maxspeed = 8,
	starttime = 60000,
	countdown = 2400,
	bonusflytime = 700,
}

-------------------------------------------------------------------------------
-- Functions for data description

function DefineProductType(t)
	t = t or {}
	if type(t) == "string" then t = { name=t } end
	
	t.products = {}
	t.knownCount = 0
	return LProductType:new(t)
end

-------------------------------------------------------------------------------
-- "static" functions to access global lists

function LProductType:ByName(name)
	return self._ByName[name]
end

function LProductType:ByIndex(n)
	return self._ByIndex[n]
end

-------------------------------------------------------------------------------
-- "constructor"

function LProductType:new(t)
	-- Standard object creation...
	t = t or {} setmetatable(t, self) self.__index = self

	-- Check parameters
	if not t.name then
		bsgDevWarning("Product Type defined with no name")
	elseif self._ByName[t.name] then
		bsgDevWarning("Product Type " .. t.name .. " already defined")
	else
		self._ByName[t.name] = t
		table.insert(self._ByIndex, t)
		return t
	end
	
	return nil
end

-------------------------------------------------------------------------------
-- Tracking products by type

function LProductType:ProductsInType()
	return bsgArrayIterator(self.products)
end

function LProductType:AddProduct(i)
	table.insert(self.products, i)
end

-------------------------------------------------------------------------------
-- Tracking known recipes by type

function LProductType:CountAllKnownRecipes()
	for _,t in ipairs(LProductType._ByIndex) do
		t:CountKnown()
	end
end

function LProductType:CountKnown()
	self.knownCount = 0
	for prod in self:ProductsInType() do
		if prod.recipe and prod.known then
			self.knownCount = self.knownCount + 1
		end
	end
end

function LProductType:IncrementKnownCount()
	self.knownCount = self.knownCount + 1
end

-------------------------------------------------------------------------------
-- Reset

function LProductType:ResetAll()
	for _,t in pairs(self._ByName) do
		t.knownCount = 0
	end
end
